globals [ balls y-upper-bound counters ]
breeds [ pegs falling-balls piling-balls piled-balls ]
patches-own [ shade ]

to setup
  ca
  set-default-shape turtles "circle"
  set balls 0
  ; need y-upper-bound to be even
  set y-upper-bound screen-edge-y - 2 + (screen-edge-y mod 2)
  setup-pegs
end

to go
  let stop-running? false
  if balls < number-of-balls
    [ new-ball ]
  balls-fall
  ask counters
    [ if any? falling-balls-at 0 1 
        [ ask falling-balls-at 0 1 [ set breed piling-balls ]
          set plabel plabel + 1 
        ]
      ; stop running when the pile of balls reaches the green patches
      if any? piled-balls-at 0 -1 [ set stop-running? true ]   
    ]
  ifelse pile-up? ; if not pile-up, just kill balls at bucket
     [ pile-up-balls ]
     [ ask piling-balls [ die ] ] 
  if stop-running? or (not any? piling-balls and not any? falling-balls)
  [
    while [any? piling-balls]
    [ pile-up-balls ]
    stop
  ]
  set-peg-angle
  do-trials
end

to setup-pegs
  set-default-shape pegs "default"
  ask patches with [valid-pycor? pycor and valid-pxcor? pxcor pycor]
    [ sprout-pegs 1 [ set color yellow ] ] 
  set-peg-angle
  set counters patches with [valid-counter-patch? pycor]
  ask counters
    [ set plabel 0
      set pcolor scale-color green 40 50 0
      ; set the serial labels at the bottom of the graphics screen
      set plabel-of (patch pxcor (- screen-edge-y)) round ((number-of-rows + pxcor) / 2)
    ]
end

to new-ball
  create-custom-falling-balls 1 
    [ set color red
      set heading 180
      set xcor 0
      set ycor screen-edge-y - 1 + screen-edge-y mod 2
    ]
  set balls balls + 1
end

to balls-fall
  ask falling-balls [
    fd 1
    shade-patch
    fd 1
    shade-patch
  ]
end

to do-trials
  ask falling-balls
    [ ifelse random-float 100 < chance-of-bouncing-right
        [ lt 90 ] ; actually turning right
        [ rt 90 ] ; actually turning left
      fd 1
      shade-patch
      set heading 180
    ]
end

;; pile up balls in columns
to pile-up-balls
  ask piling-balls 
    [ pu
      repeat 2
      [
        ifelse ycor != (1 - screen-edge-y) and not any? piled-balls-at 0 -1
          ; have to make sure piling-balls aren't on top of each other
          [ if not any? piling-balls-at 0 -1 [ fd 1 ] ]
          [ set breed piled-balls ]
      ]
    ]
end

to set-peg-angle
  ask pegs
    [ ifelse chance-of-bouncing-right >= 50
        [ set heading 360 - (chance-of-bouncing-right - 50) * 0.9 ]
        [ set heading 45 - (chance-of-bouncing-right * 0.9) ]
    ]
end

;; shades the path of the balls, but only to a certain darkness
;; you can adjust the darkness by changing the value of darkness
to shade-patch 
  let darkness 1.5
  if shade-path?
    [ ask patch-here
        [ if shade < number-of-balls / darkness
          [ set shade shade + 2
            set pcolor scale-color blue shade number-of-balls 0 
          ]
        ]
    ]
end

;;; predicate like reporters that help with graphic drawing
;;; valid coordinates depend on the number of rows in the triangle
;; a valid y coordinate is even coordinate, below the y-upper-bound
to-report valid-pycor? [y]
  report y >= y-upper-bound - (2 * number-of-rows) and y <= y-upper-bound and y mod 2 = 0
end

;; a valid x coordinate depends on a patches y coordinate
;; vertically, patches with valid x coordinates alter from having
;; odd to even pxcor
to-report valid-pxcor? [x y]
  if x <= pxcor-bounds y and x >= (- (pxcor-bounds y))
    [ if (pxcor-bounds y) mod 2 = 0 and x mod 2 = 1 and x != 0
        [ report true ]
      if (pxcor-bounds pycor) mod 2 = 1 and pxcor mod 2 = 0
        [ report true ]
    ]
  report false
end

;; below last row and inline with a peg
to-report valid-counter-patch? [y]
  report y = y-upper-bound - 2 * (number-of-rows + 1) and (any? pegs-at 1 2 or any? pegs-at -1 2)  
end

;; helps restrict pxcor depending on the size of y.
;; lower y ~ larger pxcor range
to-report pxcor-bounds [y]
  report (y-upper-bound - y) / 2
end


; *** NetLogo Model Copyright Notice ***
;
; This model was created as part of the project:
; PARTICIPATORY SIMULATIONS: NETWORK-BASED DESIGN FOR SYSTEMS LEARNING IN
; CLASSROOMS.  The project gratefully acknowledges the support of the
; National Science Foundation (REPP program) -- grant number REC #9814682.
;
; Copyright 2002 by Uri Wilensky.  Updated 2002.  All rights reserved.
;
; Permission to use, modify or redistribute this model is hereby granted,
; provided that both of the following requirements are followed:
; a) this copyright notice is included.
; b) this model will not be redistributed for profit without permission
;    from Uri Wilensky.
; Contact Uri Wilensky for appropriate licenses for redistribution for
; profit.
;
; To refer to this model in academic publications, please use:
; Wilensky, U. (2002).  NetLogo Galton Box model.
; http://ccl.northwestern.edu/netlogo/models/GaltonBox.
; Center for Connected Learning and Computer-Based Modeling,
; Northwestern University, Evanston, IL.
;
; In other publications, please use:
; Copyright 1998 by Uri Wilensky.  All rights reserved.  See
; http://ccl.northwestern.edu/netlogo/models/GaltonBox
; for terms of use.
;
; *** End of NetLogo Model Copyright Notice ***
@#$#@#$#@
GRAPHICS-WINDOW
231
10
556
590
17
30
9.0
1
10
1
1
1
0

CC-WINDOW
5
604
565
699
Command Center

SLIDER
12
86
208
119
number-of-rows
number-of-rows
1
15
12
1
1
NIL

BUTTON
29
41
106
74
setup
setup
NIL
1
T
OBSERVER
T
NIL

SLIDER
12
129
208
162
number-of-balls
number-of-balls
1
1000
75
1
1
NIL

SLIDER
4
171
226
204
chance-of-bouncing-right
chance-of-bouncing-right
0.0
100.0
50.0
1.0
1
%

BUTTON
118
41
194
74
go
go
T
1
T
OBSERVER
T
NIL

SWITCH
44
213
174
246
shade-path?
shade-path?
1
1
-1000

SWITCH
58
255
163
288
pile-up?
pile-up?
0
1
-1000

@#$#@#$#@
WHAT IS IT?
-----------
A Galton Box is a triangular board that contains several rows of staggered but equally spaced pegs.  Balls are dropped from the top, bounce off the pegs and stack up at the bottom of the triangle.  In this model, the user is able to adjust the probability of the balls bouncing right or left when it hits a peg.  

The model enables you to observe how nature produces the binomial coefficients from Pascal's Triangle and their relation to a Gaussian bell-shaped normal curve. The model can also simulate coin tossing experiments with biased coins which result in skewed distributions

There are many applications for the concepts encompassed in a Galton Box.  People employed in a wide variety of fields use binomial and normal distributions to make precise calculations about the likelihood of events or groups of events occurring.
 

HOW TO USE IT                    
-------------
Click the SETUP to set up the rows of the triangle, the number of balls, and other parameters.  Click to GO button to begin the simulation.

The SLOW-DOWN slider controls how fast the model is running.  The larger the value, the slower the model runs.  

The SHADE-PATH? button gives the user the option to have the balls chart their path as they fall down the triangle.  The more balls that cover a particular path, the darker the path will become.  This option provides a graphical tool that helps the user define the most used path.

The PILE-UP? button controls if the balls create piles or simply disappear when they reach the bottom of the triangle.  If PILE-UP? is on and the pile of balls reaches the bottom of the triangle, the model will stop.  Note: If you are running a simulation with a  large number of balls you might want to turn PILE-UP? off.


THINGS TO NOTICE
----------------
With a small number of balls it is hard to notice any patterns as the balls pile up.

As you increase the number of balls, clear patterns and distributions start to form.  By adjusting the CHANCE-OF-BOUNCING-RIGHT you can see how different factors can change the distribution of balls.  What types of distributions form when the CHANCE-OF-BOUNCING-RIGHT is set at 20, 50, or 100?

This model is a good example of an independent trials process.  Each ball has a probability of turning one way, and its decision is unrelated to that of any of the other balls.  The large number of rows the balls must travel affects the amount of variation present in a run of the model.


THINGS TO TRY
-------------
Change the NUMBER-OF-BALLS and NUMBER-OF-ROWS sliders.  How does varying numbers alter how balls stack up?

Change the CHANCE-OF-BOUNCING-RIGHT slider as balls have begun to fall.  What kinds of ball distributions can you produce?

Change the NUMBER-OF-BALLS slider.  What is the best way to produce a standard binomial distribution (or approximate a bell curve)?

Set a CHANCE-OF-BOUNCING-RIGHT then try to predict the resulting stacks of balls.  How would you calculate the mean and variances of a given stack for a given setting?


EXTENDING THE MODEL
-------------------
Modify the program to allow independent adjustment of each peg, so that they can adjust their own orientation, rather than having all the pegs synchronized.

Change the shape of the board.  Maybe flip the triangle upside down.  How does this effect how the balls get distributed?

In addition to changing the shape of the board, change the direction balls can go.  Maybe allow balls to go in all directions.

Make it so you can select a specific peg.  If a ball bounces off that peg, stop the ball.  Keep track of how many balls are stopped.  What specific insight does this provide about the independent trials process and ball distributions?.


RELATED MODELS
--------------
Binomial Rabbits, Random Walk Left Right


NETLOGO FEATURES
----------------
SHADE-PATH? enables balls to increment the shade of the path they travel.  You can easily modify this function to allow different shades.  You might want to try setting a tolerance, so when a specific path is traveled a certain number of times it turns a different color.


CREDITS AND REFERENCES
----------------------
To refer to this model in academic publications, please use: Wilensky, U. (2001).  NetLogo Galton Box model. http://ccl.northwestern.edu/netlogo/models/GaltonBox. Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL.

In other publications, please use: Copyright 2001 by Uri Wilensky.  All rights reserved.  See http://ccl.northwestern.edu/netlogo/models/GaltonBox for terms of use.
@#$#@#$#@
default
true
0
Polygon -7566196 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7566196 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7566196 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7566196 true true 150 285 285 225 285 75 150 135
Polygon -7566196 true true 150 135 15 75 150 15 285 75
Polygon -7566196 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7566196 true true 96 182 108
Circle -7566196 true true 110 127 80
Circle -7566196 true true 110 75 80
Line -7566196 true 150 100 80 30
Line -7566196 true 150 100 220 30

butterfly
true
0
Polygon -7566196 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7566196 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7566196 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7566196 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7566196 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7566196 true true 47 195 58
Circle -7566196 true true 195 195 58

circle
false
0
Circle -7566196 true true 30 30 240

circle 2
false
0
Circle -7566196 true true 16 16 270
Circle -16777216 true false 46 46 210

cow
false
0
Polygon -7566196 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7566196 true true 73 210 86 251 62 249 48 208
Polygon -7566196 true true 25 114 16 195 9 204 23 213 25 200 39 123

face happy
false
0
Circle -7566196 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7566196 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7566196 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7566196 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7566196 true true 60 15 75 300
Polygon -7566196 true true 90 150 270 90 90 30
Line -7566196 true 75 135 90 135
Line -7566196 true 75 45 90 45

flower
false
0
Polygon -11352576 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7566196 true true 85 132 38
Circle -7566196 true true 130 147 38
Circle -7566196 true true 192 85 38
Circle -7566196 true true 85 40 38
Circle -7566196 true true 177 40 38
Circle -7566196 true true 177 132 38
Circle -7566196 true true 70 85 38
Circle -7566196 true true 130 25 38
Circle -7566196 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -11352576 true false 189 233 219 188 249 173 279 188 234 218
Polygon -11352576 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7566196 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7566196 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7566196 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7566196 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7566196 true 150 0 150 300

pentagon
false
0
Polygon -7566196 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7566196 true true 110 5 80
Polygon -7566196 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7566196 true true 127 79 172 94
Polygon -7566196 true true 195 90 240 150 225 180 165 105
Polygon -7566196 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7566196 true true 135 90 165 300
Polygon -7566196 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7566196 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7566196 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7566196 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7566196 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7566196 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7566196 true true 135 90 120 45 150 15 180 45 165 90

square
false
0
Rectangle -7566196 true true 30 30 270 270

square 2
false
0
Rectangle -7566196 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7566196 true true 60 270 150 0 240 270 15 105 285 105
Polygon -7566196 true true 75 120 105 210 195 210 225 120 150 75

target
false
0
Circle -7566196 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7566196 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7566196 true true 120 120 60

tree
false
0
Circle -7566196 true true 118 3 94
Rectangle -6524078 true false 120 195 180 300
Circle -7566196 true true 65 21 108
Circle -7566196 true true 116 41 127
Circle -7566196 true true 45 90 120
Circle -7566196 true true 104 74 152

triangle
false
0
Polygon -7566196 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7566196 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7566196 true true 4 45 195 187
Polygon -7566196 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7566196 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7566196 false true 24 174 42
Circle -7566196 false true 144 174 42
Circle -7566196 false true 234 174 42

turtle
true
0
Polygon -11352576 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -11352576 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -11352576 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -11352576 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -11352576 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7566196 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7566196 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7566196 true 150 285 150 15
Line -7566196 true 15 150 285 150
Circle -7566196 true true 120 120 60
Line -7566196 true 216 40 79 269
Line -7566196 true 40 84 269 221
Line -7566196 true 40 216 269 79
Line -7566196 true 84 40 221 269

x
false
0
Polygon -7566196 true true 270 75 225 30 30 225 75 270
Polygon -7566196 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 2.1beta4
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
